/*
* 	iterate Copyright (C) 2017-2025 Jérémy Pagès <jer.pages@tutanota.com>
*
*	This file is part of iterate.
*
*	iterate is free software: you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation, either version 3 of the License, or
*	(at your option) any later version.
*
*	iterate is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with iterate.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "colors.h"

ColorMap parse_colormap(char *name) {
	char path[80] = "config/";
	strncat(path, name, 80);
	FILE *config_file = fopen(path, "r");

	if (config_file == NULL)
		fprintf(stderr, "Cannot open the color file %s\n", path);

	char line[80];

	ColorMap cm;
	int component;
	cm.red = malloc(sizeof(ControlPoint));
	cm.green = malloc(sizeof(ControlPoint));
	cm.blue = malloc(sizeof(ControlPoint));
	cm.red_count = 0;
	cm.green_count = 0;
	cm.blue_count = 0;

	while ((fgets(line, 80, config_file)) != NULL) {
		if (!strcmp(line, "[red]\n")) {
			component = RED;
		}
		else if (!strcmp(line, "[green]\n")) {
			component = GREEN;
		}
		else if (!strcmp(line, "[blue]\n")) {
			component = BLUE;
		}
		else {
			if (strlen(line) > 1) {
				ControlPoint cp;
				cp.x = strtod(strtok(line, "\t"), NULL);
				cp.y = strtod(strtok(NULL, "\t"), NULL);
				switch(component) {
					case RED:
						cm.red_count++;
						cm.red = realloc(cm.red, cm.red_count * sizeof(ControlPoint));
						cm.red[cm.red_count - 1] = cp;
						break;
					case GREEN:
						cm.green_count++;
						cm.green = realloc(cm.green, cm.green_count * sizeof(ControlPoint));
						cm.green[cm.green_count - 1] = cp;
						break;
					case BLUE:
						cm.blue_count++;
						cm.blue = realloc(cm.blue, cm.blue_count * sizeof(ControlPoint));
						cm.blue[cm.blue_count - 1] = cp;
						break;
				}
			}
		}
	}

	fclose(config_file);
	return cm;
}

ColorList default_colors(int count) {
	ColorList colors;
	colors.array = malloc((count + 1) * sizeof(Color));

	Color white;
	white.red = 255;
	white.green = 255;
	white.blue = 255;

	for (int i = 0; i <= count; i++) {
		colors.array[i] = white;
	}

	return colors;
}

ColorList compute_colors(char *name, int count) {
	ColorList colors;
	colors.array = malloc((count + 1) * sizeof(Color));
	colors.count = count;
	ColorMap map = parse_colormap(name);

	if (!strcmp(name, ""))
		return default_colors(count);

	for (int i = 0; i <= count; i++) {
		double x = (double) i / (double) count;
		Color c;

		int j = 0;
		while (j < map.red_count && (x < map.red[j].x || x > map.red[j+1].x)) {
			j++;
		}
		c.red = 255 * (map.red[j].y + (x - map.red[j].x) * (map.red[j+1].y - map.red[j].y)
			/ (map.red[j+1].x - map.red[j].x));

		j = 0;
		while (j < map.green_count && (x < map.green[j].x || x > map.green[j+1].x)) {
			j++;
		}
		c.green = 255 * (map.green[j].y + (x - map.green[j].x) * (map.green[j+1].y - map.green[j].y)
			/ (map.green[j+1].x - map.green[j].x));

		j = 0;
		while (j < map.blue_count && (x < map.blue[j].x || x > map.blue[j+1].x)) {
			j++;
		}
		c.blue = 255 * (map.blue[j].y + (x - map.blue[j].x) * (map.blue[j+1].y - map.blue[j].y)
			/ (map.blue[j+1].x - map.blue[j].x));
		colors.array[i] = c;
	}

	return colors;
}
