/*
* 	iterate Copyright (C) 2017-2025 Jérémy Pagès <jer.pages@tutanota.com>
*
*	This file is part of iterate.
*
*	iterate is free software: you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation, either version 3 of the License, or
*	(at your option) any later version.
*
*	iterate is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with iterate.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef COLORS_H
#define COLORS_H

typedef enum {
	RED,
	GREEN,
	BLUE
} Components;

typedef struct {
	double x;
	double y;
} ControlPoint;

typedef struct {
	char *name;
	ControlPoint *red;
	ControlPoint *green;
	ControlPoint *blue;
	int red_count;
	int green_count;
	int blue_count;
} ColorMap;

typedef struct {
	int red;
	int green;
	int blue;
} Color;

typedef struct {
	Color *array;
	int count;
} ColorList;

ColorMap parse_colormap(char *name);
ColorList compute_colors(char *name, int count);

#endif
