/*
* 	iterate Copyright (C) 2017-2025 Jérémy Pages <jer.pages@tutanota.com>
*	
*	This file is part of iterate.
*
*	iterate is free software: you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation, either version 3 of the License, or
*	(at your option) any later version.
*
*	iterate is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with iterate.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 *	PNG file writing function
 */

#include <stdio.h>
#include <stdlib.h>
#include <png.h> 
#include <unistd.h>

#include "colors.h"

int write_png(char *filename, int width, int height, unsigned int *buffer, ColorList colors)
{
	FILE *fp = NULL;
	png_structp png_ptr = NULL;
	png_infop info_ptr = NULL;	
	png_bytep row = NULL;

	// Open file
	fp = fopen(filename, "wb");
	if(fp == NULL)	{
		fprintf(stderr, "Error in opening the output file\n");
	}

	//Initializations
	
	png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
	if(png_ptr == NULL)
		fprintf(stderr, "Could not create the PNG write struct\n");
	info_ptr = png_create_info_struct(png_ptr);
	if(info_ptr == NULL)
		fprintf(stderr, "Could not create the PNG info struct\n");

	png_init_io(png_ptr, fp);

	// Header
	png_set_IHDR(png_ptr,info_ptr,width,height,8,PNG_COLOR_TYPE_RGB,PNG_INTERLACE_NONE,
			PNG_COMPRESSION_TYPE_BASE,PNG_FILTER_TYPE_BASE);
	png_write_info(png_ptr, info_ptr);

	// Write data
	row = (png_bytep) malloc(3 * width * sizeof(png_byte));
	if (row == NULL) {
		fprintf(stderr, "Error in allocating memory for image row\n");
		exit(EXIT_FAILURE);
	}

	int x, y;
	for(y=0;y<height;y++)	{
		for(x=0;x<width;x++)	{
			int pixel_value = buffer[y*width + x];
			if(pixel_value == 0)	{	// Point in set : black pixel
				row[3*x] = 0;
				row[3*x + 1] = 0;
				row[3*x + 2] = 0;
			}
			else {
				row[3*x] 	= colors.array[pixel_value % colors.count].red;
				row[3*x + 1] = colors.array[pixel_value % colors.count].green;
				row[3*x + 2] = colors.array[pixel_value % colors.count].blue;
			}
		}
		png_write_row(png_ptr, row);
	}
	png_write_end(png_ptr, NULL);

	// Finalization
	fclose(fp);
	png_free_data(png_ptr,info_ptr,PNG_FREE_ALL,-1);
	png_destroy_write_struct(&png_ptr, (png_infopp)NULL);
	free(row);

	return 0;
}
