require 'bcrypt'
require 'rom'

module DB
  extend self

  def setup()
    config = ROM::Configuration.new(:sql, 'postgres://localhost/esmeralda',
      username: 'esmeralda', password: ENV['DATABASE_PASSWORD'])
    @rom = ROM.container(config)
  end

  def start()
    config = ROM::Configuration.new(:sql, 'postgres://localhost/esmeralda',
      username: 'esmeralda', password: ENV['DATABASE_PASSWORD'])
    config.auto_registration('./db', namespace: false)
    @rom = ROM.container(config)
  end

  def init()
    config = ROM::Configuration.new(:sql, 'postgres://localhost/esmeralda',
      username: 'esmeralda', password: ENV['DATABASE_PASSWORD'])
    config.auto_registration('./db', namespace: false)
    @rom = ROM.container(config)
    @rom.relations[:accounts].changeset(:create, login: "admin",
      name: "Esmeralda Administrator",
      hash: BCrypt::Password.create(ENV['ADMIN_PASSWORD']),
      created_at: Time.new).commit
  end

  def rom()
    return @rom
  end
end
