#! /usr/bin/env ruby

require 'dotenv'
require 'rom'
require 'rom-sql'
require 'sinatra/base'
require 'securerandom'
require_relative 'db/db'
require_relative 'app/helpers'

class Esmeralda < Sinatra::Base
  configure do
    Dotenv.load
    DB.start
    set :views, "app/views"
    enable :sessions
    set :session_secret, ENV.fetch('SESSION_SECRET') { SecureRandom.hex(64) }
    set :host_authorization, { permitted_hosts: [] }
    set :blog_name, "blog.jpages.eu"
  end

  get '/' do
    redirect '/articles'
  end

  helpers SessionUtils, Markdown
end
