# Esmeralda CMS

Esmeralda is a simple blog engine, written in Ruby with the Sinatra framework.
Articles can be written using the Kramdown format (a Markdown superset).

## Installation

### Esmeralda user creation

~~~
# useradd -d /home/esmeralda esmeralda
# mkdir -p /home/esmeralda
# chown -R esmeralda:<group_name> /home/esmeralda
~~~

Then, download the Esmeralda archive, and extract it to the appropriate destination.

### PostgreSQL

Create a "Esmeralda" user, and the database with the following SQL request :

~~~sql
CREATE ROLE esmeralda LOGIN ENCRYPTED PASSWORD 'password';
CREATE DATABASE esmeralda WITH ENCODING='utf8' OWNER=esmeralda;
~~~

The password you chose must be set in the .env file.

### Ruby and gems

First, install Ruby (version >= 3.2.0, requires ruby-build) :

~~~
$ rbenv install <ruby_version>
~~~

If a correct version of Ruby isn't available in your distribution, you can proceed the following way :

~~~
$ git clone https://github.com/rbenv/rbenv.git ~/.rbenv
$ git clone https://github.com/rbenv/ruby-build.git "$(rbenv root)"/plugins/ruby-build
$ rbenv install
~~~

Then, install the dependencies listed in Gemfile.

~~~
$ export PATH=~/.rbenv/shims:$PATH
$ rbenv global <ruby_version>
$ bundle config set --local without 'development test'
$ bundle config set --local path 'vendor/bundle'
$ bundle install
~~~

### Configuration

The blog name and the port number can be set in the esmeralda.rb file, with the instructions :

~~~ruby
set :blog_name, <your_blog_domain>
set :port, <your_port_number>
~~~

Then, set the database password and the admin password in the .env file.

### Database initialization.

Construct the database schema, and add an admin account in the accounts table.

~~~
$ bundle exec rake db:migrate
$ bundle exec rake db:init
~~~

### Nginx configuration

~~~
	upstream puma_esmeralda {
		server unix:///home/esmeralda/esmeralda-0.1.0/tmp/puma/socket;
	}

	server {
		listen 80;
		listen [::]:80;
		server_name <your_blog_domain>;

		root /home/esmeralda/esmeralda-0.1.0/public;

		rewrite ^/login(.*) https://<your_blog_domain>$request_uri permanent;
		rewrite ^/logout(.*) https://<your_blog_domain>$request_uri permanent;
		rewrite ^/register(.*) https://<your_blog_domain>$request_uri permanent;
		rewrite ^/accounts/edit(.*) https://<your_blog_domain>$request_uri permanent;
		rewrite ^/articles/new(.*) https://<your_blog_domain>$request_uri permanent;
		rewrite ^/articles/edit(.*) https://<your_blog_domain>$request_uri permanent;

		location / {
			try_files $uri @puma;
		}

		location @puma {
			proxy_set_header Host $http_host;
			proxy_set_header X-Forwarded-Proto $scheme;
			proxy_set_header X-Real-IP $remote_addr;
			proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
			proxy_redirect off;
			proxy_read_timeout 300;
			proxy_pass http://puma_esmeralda;
		}

		access_log /var/log/nginx/esmeralda_access.log main;
		error_log /var/log/nginx/esmeralda_error.log info;
	}

	server {
		listen 443;
		listen [::]:443 ssl;

		server_name <your_blog_domain>;

		root /home/esmeralda/esmeralda-0.1.0/public;

		ssl_protocols TLSv1 TLSv1.1 TLSv1.2;
		ssl_session_cache    shared:SSL:10m;

		ssl_certificate      /etc/letsencrypt/live/<your_blog_domain>/fullchain.pem;
		ssl_certificate_key  /etc/letsencrypt/live/<your_blog_domain>/privkey.pem;
		ssl_dhparam     /etc/nginx/ssl/dhparam.pem;

		ssl_session_timeout  5m;

		location / {
			try_files $uri @puma;
		}

		location @puma {
			proxy_set_header Host $http_host;
			proxy_set_header X-Forwarded-Proto $scheme;
			proxy_set_header X-Real-IP $remote_addr;
			proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
			proxy_redirect off;
			proxy_read_timeout 300;
			proxy_pass http://puma_esmeralda;
		}

		access_log /var/log/nginx/esmeralda_ssl_access.log main;
	}
~~~


### TLS certificate (with Letsencrypt)

~~~
# certbot certonly --standalone -d <your_blog_domain>
~~~

### Session secret creation

~~~
$ ruby -e "require 'securerandom'; puts SecureRandom.hex(64)"
$ echo "export SESSION_SECRET=<secret>" >> ~/.bashrc
~~~

### Launch

~~~
$ bundle exec puma -C config/puma.rb &
~~~

## License

AGPLv3. See the COPYING file.
