require "rom"
require "sinatra/base"
require_relative "../../db/db"

class CommentsController < Esmeralda
  get "/comments/:id" do
    @comment = DB.rom.relations[:comments].by_pk(params[:id])
    haml :'comments/show'
  end

  post "/comments/new/:id" do
    create_comment = DB.rom.relations[:comments].command(:create)
    create_comment.call(author: params[:author], email: params[:email],
      text: params[:text], created_at: Time.now, article_id: params[:id])
    article_url = DB.rom.relations[:articles].by_pk(params[:id]).one![:url]
    redirect "/articles/#{article_url}"
  end
end
