require "rom"
require "sinatra/base"

require_relative "../../db/db"
require_relative "../helpers"

class ArticlesController < Esmeralda 
  get "/articles" do
    @articles = DB.rom.relations[:articles].listing
    @login = session[:login]
    @blog_name = settings.blog_name
    haml :'articles/index'
  end

  get "/articles/new" do
    @login = login()
    haml :'articles/new'
  end
	
  get "/articles/:url" do
    @login = session[:login]
    @blog_name = settings.blog_name
    @article = DB.rom.relations[:articles].by_url(params[:url]).one!
    @formatted_text = kramdown(@article[:text]).to_html
    tag_ids = DB.rom.relations[:articles_tags].tags(@article[:id]).pluck(:tag_id)
    @tags = DB.rom.relations[:tags].names(tag_ids).pluck(:name)
    @comments = DB.rom.relations[:comments].by_article(@article[:id])
    haml :'articles/show'
  end

  post "/articles" do
    @login = login()

    create_article = DB.rom.relations[:articles].command(:create)
    create_tag = DB.rom.relations[:tags].command(:create)
    create_article_tag = DB.rom.relations[:articles_tags].command(:create)

    title = params[:title]
    url = params[:url]
    text = params[:text]

    create_article.call(title: title, url: url, account_id: session[:id], text: text,
      created_at: Time.new)
    article_id = DB.rom.relations[:articles].by_url(url).one![:id]
    
    params[:tags].split(';').each do |t|
      begin
        tag_id = DB.rom.relations[:tags].by_name(t).one![:id]
      rescue
        create_tag.call(name: t)
        tag_id = DB.rom.relations[:tags].by_name(t).one![:id]
      end
      create_article_tag.call(article_id: article_id, tag_id: tag_id)
    end

    redirect "/articles"
  end

  get "/articles/edit/:id" do
    @login = login()
    @article = DB.rom.relations[:articles].by_id(params[:id]).one!
    tag_ids = DB.rom.relations[:articles_tags].tags(params[:id]).pluck(:tag_id)
    @tags = DB.rom.relations[:tags].names(tag_ids).pluck(:name).join(';')
    haml :'articles/edit'
  end

  post "/articles/edit" do
    @login = login()

    update_article = DB.rom.relations[:articles].by_pk(params[:id]).command(:update)
    update_article.call(title: params[:title], url: params[:url], text: params[:text])
   
    delete_article_tag = DB.rom.relations[:articles_tags].tags(params[:id]).command(:delete)
    delete_article_tag.call
    
    create_tag = DB.rom.relations[:tags].command(:create)
    create_article_tag = DB.rom.relations[:articles_tags].command(:create)

    params[:tags].split(';').each do |t|
      begin
        tag_id = DB.rom.relations[:tags].by_name(t).one![:id]
      rescue
        create_tag.call(name: t)
        tag_id = DB.rom.relations[:tags].by_name(t).one![:id]
      end
      create_article_tag.call(article_id: params[:id], tag_id: tag_id)
    end

    redirect "/articles"
  end
end
