# frozen_string_literal: true

ROM::SQL.migration do
  change do
    create_table :accounts do
      primary_key :id
      column :name, String, null: false
      column :login, String, null: false
      column :hash, String, null: false
      column :created_at, DateTime, null: false
    end

    alter_table :articles do
      drop_column :author
      add_foreign_key :account_id, :accounts
    end
  end
end
