class Articles < ROM::Relation[:sql]
  schema(:articles, infer: true) do
    associations do
      belongs_to :accounts
      has_many :articles_tags
      has_many :tags, through: :articles_tags
      has_many :comments
    end
  end

  def by_id(id)
    join(accounts, id: :account_id).select(:id, :title, :url, accounts[:name], :created_at, :text).by_pk(id)
  end
  
  def by_url(url)
    join(accounts, id: :account_id).select(:id, :title, :url, accounts[:name], :created_at, :text).where(url: url)
  end

  def by_title(title)
    where(title: title)
  end

  def listing()
    join(accounts, id: :account_id).select(:id, :title, :url, accounts[:name], :created_at).order(:created_at)
  end

  def filtered_listing(ids)
    join(accounts, id: :account_id).select(:id, :title, :url, accounts[:name], :created_at).by_pk(ids).order(:created_at)
  end
end
