class Tags < ROM::Relation[:sql]
  schema(:tags, infer: true) do 
    associations do
      has_many :articles_tags
      has_many :articles, through: :articles_tags
    end
  end

  def by_name(name)
    where(name: name)
  end

  def names(ids)
    select(:name).where(id: ids)
  end
end
