class ArticlesTags < ROM::Relation[:sql]
  schema(:articles_tags, infer: true) do
    associations do
      has_many :articles
      has_many :tags
    end
  end

  def articles(tag_id)
    where(tag_id: tag_id)
  end

  def tags(article_id)
    where(article_id: article_id)
  end
end
