#! /usr/bin/env ruby

require 'builder'
require 'dotenv'
require 'rom'
require 'rom-sql'
require 'sinatra/base'
require 'securerandom'
require_relative 'db/db'
require_relative 'app/helpers'

class Esmeralda < Sinatra::Base
  configure do
    Dotenv.load
    DB.start
    set :views, "app/views"
    enable :sessions
    set :session_secret, ENV.fetch('SESSION_SECRET') { SecureRandom.hex(64) }
    set :host_authorization, { permitted_hosts: [] }
    set :base_url, ENV['BASE_URL']
    set :blog_name, ENV['BLOG_NAME']
  end

  get '/' do
    redirect '/articles'
  end

  get '/rss.xml' do
    @articles = DB.rom.relations[:articles].listing.reverse
    builder :'rss.xml'
  end

  helpers SessionUtils, Markdown
end
