xml = Builder::XmlMarkup.new(:indent => 2)
xml.instruct! :xml, :version => "1.0", :encoding => "UTF-8"
xml.rss :version => "2.0" do
  xml.channel do
    xml.title(settings.blog_name)
    xml.description
    xml.lastBuildDate(@articles.map {|article| article[:created_at]}.max)
    xml.link(settings.base_url)
    @articles.each do |article|
      xml.item do
        xml.title(article[:title])
        xml.pubDate(article[:created_at])
        xml.description(article[:intro])
        xml.link("https://%s/%s" % [settings.base_url, article[:url]])
      end
    end
  end
end
