require "rom"
require "sinatra/base"

require_relative "../../db/db"
require_relative "../helpers"

class TagsController < Esmeralda
  get "/tags/:name" do
    @login = session[:login]
    tag_id = DB.rom.relations[:tags].by_name(params['name']).pluck(:id)
    articles_ids = DB.rom.relations[:articles_tags].articles(tag_id).pluck(:article_id)
    @articles = DB.rom.relations[:articles].filtered_listing(articles_ids)
    @blog_name = settings.blog_name
    haml :'/tags/index'
  end
end
