require "bcrypt"
require "rom"
require "sinatra/base"

require_relative "../../db/db"
require_relative "../helpers"

class AccountsController < Esmeralda
  get "/login" do
    @error = params[:error]
    haml :'accounts/login'
  end

  post "/login" do
    login = params[:login]
    begin
      @account = DB.rom.relations[:accounts].by_login(login).one!
      password = BCrypt::Password.new(@account[:hash])
      if password == params[:password]
        session[:id] = @account[:id]
        session[:login] = login
        redirect "/articles"
      else
        redirect "/login?error=true"
      end
    rescue
      redirect "/login?error=true"
    end
  end

  post "/logout" do
    session.clear
    redirect "/articles"
  end

  get "/register" do
    check_admin()
    haml :'accounts/register'
  end

  post "/register" do
    check_admin()
    account = DB.rom.relations[:accounts]
    create_account = account.command(:create)

    name = params[:name]
    login = params[:login]
    email = params[:email]
    hash = BCrypt::Password.create(params[:password])

    create_account.call(name: name, login: login, email: email, hash: hash,
      created_at: Time.new)
    redirect "/register"
  end

  get "/accounts/edit" do
    @login = login()
    @account = DB.rom.relations[:accounts].by_login(@login).one!
    haml :'accounts/edit'
  end

  post "/accounts/edit" do
    @login = login()
    account = DB.rom.relations[:accounts].by_login(@login)
    update_account = account.command(:update)

    name = params[:name]
    email = params[:email]
    hash = BCrypt::Password.create(params[:password])

    update_account.call(name: name, email: email, hash: hash)
    session.clear
    redirect "/login"
  end
end
