/*
* 	iterate Copyright (C) 2017-2025 Jérémy Pagès <jer.pages@tutanota.com>
*
*	This file is part of iterate.
*
*	iterate is free software: you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation, either version 3 of the License, or
*	(at your option) any later version.
*
*	iterate is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with iterate.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 *	Draws a Mandelbrot fractal (900*800 pixels)
 *
 */

#include <complex.h>
#include <stdio.h>
#include <stdlib.h>

#include "drawpng.h"
#include "mandelbrot.h"

unsigned int divergence(double complex c, int max_iter)
{
	int iter = 1;

	double complex c_iter = c; 
	double complex c_new;

	while (iter <= max_iter) {
		if (creal(c_iter) * creal(c_iter) + cimag(c_iter) * cimag(c_iter) > 4)
			return iter;

		c_new = c_iter * c_iter + c;
		c_iter = c_new;

		iter++;
	}

	return 0;
}

unsigned int *calc_mandelbrot(double complex center, double magn, int max_iter, int width, int height)
{
	double pixel_size = 3.0/(magn * width);

	double complex pixel_affix;
	double affix_re, affix_im;

	unsigned int *buffer = malloc((width * height) * sizeof(unsigned int));
	if (buffer == NULL) {
		fprintf(stderr, "Error in allocating memory for the buffer\n");
		exit(EXIT_FAILURE);
	}

	for (int line = 0; line < height;line++) {
		for (int col = 0; col < width; col++) {
			affix_re = creal(center) + (col - width/2) * pixel_size;
			affix_im = cimag(center) - (line - height/2) * pixel_size;
		
			pixel_affix = affix_re + I*affix_im;

			buffer[line * width + col] = divergence(pixel_affix, max_iter);
		}
	}

	return buffer;
}
